<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Van Sales";

// Get latest 100 van sales with load, route, customer, amounts
$sql = "
  SELECT vs.*,
         dl.load_no,
         dl.route_code,
         c.name AS customer_name,
         c.code AS customer_code
  FROM van_sales vs
  JOIN dispatch_loads dl ON vs.load_id = dl.id
  JOIN customers c ON vs.customer_id = c.id
  ORDER BY vs.sale_date DESC, vs.id DESC
  LIMIT 100
";
$res = $conn->query($sql);

// We'll need list of posted loadings for filter / quick add
$loads = $conn->query("
  SELECT id, load_no, load_date, route_code
  FROM dispatch_loads
  WHERE status = 'Posted'
  ORDER BY load_date DESC, id DESC
")->fetch_all(MYSQLI_ASSOC);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Van Sales</h5>
      <p class="small text-muted mb-0">
        Sales done from vans &amp; bikes per route, linked to dispatch loadings.
      </p>
    </div>
    <a href="sale_form.php" class="btn btn-sm btn-primary rounded-pill"
       style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New Van Sale
    </a>
  </div>

  <?php if (!empty($loads)): ?>
    <div class="small text-muted mb-2">
      <i class="fa-solid fa-circle-info me-1"></i>
      Latest posted loadings:
      <?php foreach(array_slice($loads,0,3) as $ld): ?>
        <span class="badge rounded-pill text-bg-secondary-subtle border border-secondary-subtle me-1">
          <?php echo h($ld['load_no']); ?> · <?php echo h($ld['load_date']); ?> · <?php echo h($ld['route_code']); ?>
        </span>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Date</th>
          <th>Doc No</th>
          <th>Load / Route</th>
          <th>Customer</th>
          <th class="text-end">Total (KES)</th>
          <th>Paid By</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($row['sale_date']); ?></td>
            <td><?php echo h($row['doc_no']); ?></td>
            <td>
              <strong><?php echo h($row['load_no']); ?></strong><br>
              <span class="text-muted"><?php echo h($row['route_code']); ?></span>
            </td>
            <td>
              <strong><?php echo h($row['customer_code']); ?></strong><br>
              <span class="text-muted"><?php echo h($row['customer_name']); ?></span>
            </td>
            <td class="text-end">KES <?php echo number_format($row['total_amount'], 2); ?></td>
            <td>
              <?php echo h($row['payment_mode']); ?><br>
              <span class="text-muted">
                Cash: <?php echo number_format($row['cash_amount'], 2); ?> · 
                Mpesa: <?php echo number_format($row['mpesa_amount'], 2); ?> · 
                Cr: <?php echo number_format($row['credit_amount'], 2); ?>
              </span>
            </td>
            <td>
              <?php if ($row['status'] === 'Closed'): ?>
                <span class="badge rounded-pill text-bg-success-subtle border border-success-subtle">
                  Closed
                </span>
              <?php else: ?>
                <span class="badge rounded-pill text-bg-warning-subtle border border-warning-subtle">
                  Open
                </span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <a href="sale_form.php?id=<?php echo $row['id']; ?>"
                 class="btn btn-sm btn-outline-light rounded-pill">
                <i class="fa-regular fa-pen-to-square"></i>
              </a>
            </td>
          </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="8" class="text-center text-muted py-3">No van sales yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
