<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id           = (int)($_POST['id'] ?? 0);
$sale_date    = $_POST['sale_date'] ?? date('Y-m-d');
$doc_no       = trim($_POST['doc_no'] ?? '');
$load_id      = (int)($_POST['load_id'] ?? 0);
$customer_id  = (int)($_POST['customer_id'] ?? 0);
$payment_mode = trim($_POST['payment_mode'] ?? 'Cash');
$cash_amount  = (float)($_POST['cash_amount'] ?? 0);
$mpesa_amount = (float)($_POST['mpesa_amount'] ?? 0);
$credit_amount= (float)($_POST['credit_amount'] ?? 0);
$remarks      = trim($_POST['remarks'] ?? '');

if (!$doc_no || !$load_id || !$customer_id) {
    flash_set('error', 'Date, Doc No, Loading and Customer are required.');
    redirect("sale_form.php" . ($id ? "?id=".$id : ""));
}

// Items arrays
$product_ids = $_POST['product_id'] ?? [];
$qtys        = $_POST['qty'] ?? [];
$prices      = $_POST['unit_price'] ?? [];

$line_data = [];
$total_amount = 0;

for ($i = 0; $i < count($product_ids); $i++) {
    $pid = (int)$product_ids[$i];
    $q   = (int)$qtys[$i];
    $up  = (float)$prices[$i];

    if ($pid && $q > 0) {
        $lt = $q * $up;
        $line_data[] = [
            'product_id' => $pid,
            'qty'        => $q,
            'unit_price' => $up,
            'line_total' => $lt,
        ];
        $total_amount += $lt;
    }
}

if (empty($line_data)) {
    flash_set('error', 'Add at least one product line.');
    redirect("sale_form.php" . ($id ? "?id=".$id : ""));
}

// If user didn't fill total correctly, you can later auto-force:
// For now just leave amounts as captured.
$calc_total = $cash_amount + $mpesa_amount + $credit_amount;
// You may want to enforce equality here; for now we just save as is.

// Insert or update header
if ($id) {
    $stmt = $conn->prepare("
        UPDATE van_sales
        SET load_id=?, customer_id=?, sale_date=?, doc_no=?, payment_mode=?,
            cash_amount=?, mpesa_amount=?, credit_amount=?, total_amount=?, remarks=?
        WHERE id=?
    ");
    $stmt->bind_param(
        "iisssddddsi",
        $load_id, $customer_id, $sale_date, $doc_no, $payment_mode,
        $cash_amount, $mpesa_amount, $credit_amount, $total_amount, $remarks,
        $id
    );
    $stmt->execute();

    // Delete existing items, re-insert
    $stmt = $conn->prepare("DELETE FROM van_sales_items WHERE van_sale_id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
} else {
    $stmt = $conn->prepare("
        INSERT INTO van_sales 
        (load_id, customer_id, sale_date, doc_no, payment_mode,
         cash_amount, mpesa_amount, credit_amount, total_amount, remarks)
        VALUES (?,?,?,?,?,?,?,?,?,?)
    ");
    $stmt->bind_param(
        "iisssdddds",
        $load_id, $customer_id, $sale_date, $doc_no, $payment_mode,
        $cash_amount, $mpesa_amount, $credit_amount, $total_amount, $remarks
    );
    $stmt->execute();
    $id = $conn->insert_id;
}

// Insert items
$stmt = $conn->prepare("
    INSERT INTO van_sales_items
    (van_sale_id, product_id, qty, unit_price, line_total)
    VALUES (?,?,?,?,?)
");
foreach ($line_data as $ln) {
    $stmt->bind_param(
        "iiidd",
        $id,
        $ln['product_id'],
        $ln['qty'],
        $ln['unit_price'],
        $ln['line_total']
    );
    $stmt->execute();
}

flash_set('success', 'Van sale saved.');
redirect("sales_list.php");
