<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();
$page_title = "Van Sale";

$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM van_sales WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}

$loads = $conn->query("
  SELECT id, load_no, load_date, route_code
  FROM dispatch_loads
  WHERE status = 'Posted'
  ORDER BY load_date DESC, id DESC
")->fetch_all(MYSQLI_ASSOC);

$customers = $conn->query("
  SELECT id, code, name 
  FROM customers 
  ORDER BY name
")->fetch_all(MYSQLI_ASSOC);

$products = $conn->query("
  SELECT id, code, name, category, selling_price
  FROM products 
  WHERE status = 'Active'
  ORDER BY category, name
")->fetch_all(MYSQLI_ASSOC);

// Load existing items if editing
$items = [];
if ($id) {
    $stmt = $conn->prepare("
      SELECT vsi.*, p.code, p.name 
      FROM van_sales_items vsi
      JOIN products p ON vsi.product_id = p.id
      WHERE vsi.van_sale_id = ?
    ");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Van Sale</h5>
  <form method="post" action="sale_save.php" class="small">
    <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
    <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label">Sale Date</label>
        <input type="date" name="sale_date" class="form-control form-control-sm"
               value="<?php echo h($row['sale_date'] ?? date('Y-m-d')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Doc No</label>
        <input type="text" name="doc_no" class="form-control form-control-sm"
               value="<?php echo h($row['doc_no'] ?? 'VS-' . date('ymd-His')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Loading</label>
        <select name="load_id" class="form-select form-select-sm" required>
          <option value="">-- select posted loading --</option>
          <?php foreach($loads as $ld): ?>
            <option value="<?php echo $ld['id']; ?>"
              <?php echo ($row['load_id'] ?? 0) == $ld['id'] ? 'selected' : ''; ?>>
              <?php echo h($ld['load_no'] . ' • ' . $ld['load_date'] . ' • ' . $ld['route_code']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Customer</label>
        <select name="customer_id" class="form-select form-select-sm" required>
          <option value="">-- select customer --</option>
          <?php foreach($customers as $c): ?>
            <option value="<?php echo $c['id']; ?>"
              <?php echo ($row['customer_id'] ?? 0) == $c['id'] ? 'selected' : ''; ?>>
              <?php echo h($c['code'] . ' — ' . $c['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <hr class="border-secondary my-3">

    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label">Payment Mode</label>
        <select name="payment_mode" class="form-select form-select-sm">
          <?php
          $pm = $row['payment_mode'] ?? 'Cash';
          $modes = ['Cash','Mpesa','Mixed','Credit'];
          foreach($modes as $mode):
          ?>
            <option value="<?php echo $mode; ?>" <?php echo $pm === $mode ? 'selected' : ''; ?>>
              <?php echo $mode; ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Cash Amount</label>
        <input type="number" step="0.01" name="cash_amount" class="form-control form-control-sm"
               value="<?php echo h($row['cash_amount'] ?? '0'); ?>">
      </div>
      <div class="col-md-3">
        <label class="form-label">Mpesa Amount</label>
        <input type="number" step="0.01" name="mpesa_amount" class="form-control form-control-sm"
               value="<?php echo h($row['mpesa_amount'] ?? '0'); ?>">
      </div>
      <div class="col-md-3">
        <label class="form-label">Credit Amount</label>
        <input type="number" step="0.01" name="credit_amount" class="form-control form-control-sm"
               value="<?php echo h($row['credit_amount'] ?? '0'); ?>">
      </div>
    </div>

    <div class="mt-2">
      <label class="form-label">Remarks</label>
      <input type="text" name="remarks" class="form-control form-control-sm"
             value="<?php echo h($row['remarks'] ?? ''); ?>">
    </div>

    <hr class="border-secondary my-3">

    <h6 class="text-uppercase text-muted small mb-2">Items</h6>

    <div class="table-responsive small mb-2">
      <table class="table table-dark table-borderless align-middle mb-0">
        <thead class="text-muted text-uppercase small">
          <tr>
            <th style="width:35%;">Product</th>
            <th class="text-end" style="width:15%;">Qty</th>
            <th class="text-end" style="width:20%;">Unit Price</th>
            <th class="text-end" style="width:20%;">Line Total</th>
          </tr>
        </thead>
        <tbody>
          <?php
          // Show existing items first
          $lines = [];
          foreach ($items as $it) {
              $lines[] = [
                  'product_id' => $it['product_id'],
                  'qty'        => $it['qty'],
                  'unit_price' => $it['unit_price']
              ];
          }
          // Ensure at least 5 rows
          $minRows = 5;
          while (count($lines) < $minRows) {
              $lines[] = ['product_id' => '', 'qty' => '', 'unit_price' => ''];
          }
          foreach ($lines as $idx => $ln):
          ?>
            <tr>
              <td>
                <select name="product_id[]" class="form-select form-select-sm">
                  <option value="">-- select product --</option>
                  <?php foreach($products as $p): ?>
                    <option value="<?php echo $p['id']; ?>"
                      <?php echo (string)$ln['product_id'] === (string)$p['id'] ? 'selected' : ''; ?>>
                      <?php echo h($p['code'] . ' — ' . $p['name']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </td>
              <td class="text-end">
                <input type="number" name="qty[]" class="form-control form-control-sm text-end"
                       value="<?php echo h($ln['qty']); ?>" min="0">
              </td>
              <td class="text-end">
                <input type="number" step="0.01" name="unit_price[]" 
                       class="form-control form-control-sm text-end"
                       value="<?php echo h($ln['unit_price']); ?>">
              </td>
              <td class="text-end text-muted">
                <!-- Line total is computed on save; can enhance with JS later -->
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="d-flex justify-content-between align-items-center mt-3">
      <a href="sales_list.php" class="btn btn-sm btn-outline-light rounded-pill">
        <i class="fa-solid fa-arrow-left-long me-1"></i> Back
      </a>
      <button type="submit" class="btn btn-sm btn-primary rounded-pill"
              style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
        <i class="fa-solid fa-floppy-disk me-1"></i> Save
      </button>
    </div>
  </form>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
