<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$load_id        = (int)($_POST['load_id'] ?? 0);
$drop_date_raw  = trim($_POST['drop_date'] ?? '');
$expected_cash  = (float)($_POST['expected_cash'] ?? 0);
$expected_mpesa = (float)($_POST['expected_mpesa'] ?? 0);
$expected_credit= (float)($_POST['expected_credit'] ?? 0);
$expected_total = (float)($_POST['expected_total'] ?? 0);
$actual_cash    = (float)($_POST['actual_cash'] ?? 0);
$actual_mpesa   = (float)($_POST['actual_mpesa'] ?? 0);
$remarks        = trim($_POST['remarks'] ?? '');

if (!$load_id) {
    flash_set('error', 'Missing loading id.');
    redirect('/smartbake360/modules/dispatch/loadings_list.php');
}

// Simple normalization of date/time
$drop_date = $drop_date_raw ?: date('Y-m-d H:i:s');

// Compute actual total
$actual_total = $actual_cash + $actual_mpesa;

// Upsert route_cash_drops for this load
$stmt = $conn->prepare("
  SELECT id FROM route_cash_drops WHERE load_id = ? ORDER BY id DESC LIMIT 1
");
$stmt->bind_param("i", $load_id);
$stmt->execute();
$existing = $stmt->get_result()->fetch_assoc();

if ($existing) {
    $id = (int)$existing['id'];
    $stmt = $conn->prepare("
      UPDATE route_cash_drops
      SET drop_date=?, expected_cash=?, expected_mpesa=?, expected_credit=?, expected_total=?,
          actual_cash=?, actual_mpesa=?, actual_total=?, remarks=?
      WHERE id=?
    ");
    $stmt->bind_param(
        "sdddddddsi",
        $drop_date,
        $expected_cash,
        $expected_mpesa,
        $expected_credit,
        $expected_total,
        $actual_cash,
        $actual_mpesa,
        $actual_total,
        $remarks,
        $id
    );
    $stmt->execute();
} else {
    $stmt = $conn->prepare("
      INSERT INTO route_cash_drops
      (load_id, drop_date, expected_cash, expected_mpesa, expected_credit, expected_total,
       actual_cash, actual_mpesa, actual_total, remarks)
      VALUES (?,?,?,?,?,?,?,?,?,?)
    ");
    $stmt->bind_param(
        "isddddddds",
        $load_id,
        $drop_date,
        $expected_cash,
        $expected_mpesa,
        $expected_credit,
        $expected_total,
        $actual_cash,
        $actual_mpesa,
        $actual_total,
        $remarks
    );
    $stmt->execute();
}

flash_set('success', 'Route cash reconciliation saved.');
redirect("route_cash.php?load_id=".$load_id);
