<?php
// FILE: modules/recipes/recipe_view.php
// PURPOSE: HTML snippet for modal (no full layout)

require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";

header('Content-Type: text/html; charset=utf-8');

$product_id = isset($_GET['product_id']) ? (int)$_GET['product_id'] : 0;
if (!$product_id) {
    echo '<div class="text-danger">Missing product.</div>';
    exit;
}

// 1) Find recipe for this product
$stmt = $conn->prepare("
  SELECT r.id, r.code, r.name, r.yield_qty,
         p.code AS product_code, p.name AS product_name
  FROM recipes r
  JOIN products p ON p.id = r.product_id
  WHERE r.product_id = ?
  LIMIT 1
");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$recipe = $stmt->get_result()->fetch_assoc();

if (!$recipe) {
    echo '<div class="alert alert-warning py-2 px-3 small mb-0">
            No recipe linked to this product yet.
          </div>';
    exit;
}

$recipe_id = (int)$recipe['id'];

// 2) Load recipe items from raw_materials
$q = "
  SELECT ri.qty,
         rm.code AS material_code,
         rm.name AS material_name,
         rm.uom  AS material_uom,
         rm.current_stock,
         rm.unit_cost
  FROM recipe_items ri
  JOIN raw_materials rm ON rm.id = ri.material_id
  WHERE ri.recipe_id = ?
  ORDER BY rm.name
";
$stmt = $conn->prepare($q);
$stmt->bind_param("i", $recipe_id);
$stmt->execute();
$items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>

<div class="mb-2">
  <div class="fw-bold">
    <?php echo h($recipe['code']); ?> — <?php echo h($recipe['name']); ?>
  </div>
  <div class="small text-muted">
    Product: <?php echo h($recipe['product_code'] . ' — ' . $recipe['product_name']); ?><br>
    Yield: <strong><?php echo (int)$recipe['yield_qty']; ?></strong> unit(s) of finished product
  </div>
</div>

<?php if (empty($items)): ?>
  <div class="alert alert-warning py-2 px-3 small mb-0">
    No ingredients defined for this recipe yet.
  </div>
<?php else: ?>
  <div class="table-responsive small">
    <table class="table table-sm table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th style="width:20%;">Code</th>
          <th style="width:30%;">Material</th>
          <th class="text-end" style="width:15%;">Qty / batch</th>
          <th style="width:10%;">UOM</th>
          <th class="text-end" style="width:15%;">In Stock</th>
          <th class="text-end" style="width:10%;">Unit Cost</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $it): ?>
          <tr>
            <td><?php echo h($it['material_code']); ?></td>
            <td><?php echo h($it['material_name']); ?></td>
            <td class="text-end"><?php echo number_format($it['qty'], 3); ?></td>
            <td><?php echo h($it['material_uom']); ?></td>
            <td class="text-end"><?php echo number_format($it['current_stock'], 3); ?></td>
            <td class="text-end"><?php echo number_format($it['unit_cost'], 4); ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php endif; ?>
