<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$recipe_id = (int)($_POST['recipe_id'] ?? 0);
$material_id = (int)($_POST['material_id'] ?? 0);
$qty = (float)($_POST['qty'] ?? 0);

if (!$recipe_id || !$material_id || $qty <= 0) {
    flash_set('error', 'Fill all fields.');
    redirect("items_list.php?recipe_id=" . $recipe_id);
}

$stmt = $conn->prepare("INSERT INTO recipe_items (recipe_id, material_id, qty) VALUES (?,?,?)");
$stmt->bind_param("iid", $recipe_id, $material_id, $qty);
$stmt->execute();
flash_set('success', 'Ingredient added.');
redirect("items_list.php?recipe_id=" . $recipe_id);
