<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$recipe_id = (int)($_GET['recipe_id'] ?? 0);
if (!$recipe_id) { die("Missing recipe."); }

// header
$stmt = $conn->prepare("SELECT r.*, p.name AS product_name FROM recipes r JOIN products p ON r.product_id=p.id WHERE r.id=?");
$stmt->bind_param("i", $recipe_id);
$stmt->execute();
$recipe = $stmt->get_result()->fetch_assoc();
if (!$recipe) die("Recipe not found.");

$page_title = "Recipe Ingredients — " . $recipe['name'];

$sql = "SELECT ri.*, rm.name AS material_name, rm.uom 
        FROM recipe_items ri 
        JOIN raw_materials rm ON ri.material_id = rm.id 
        WHERE ri.recipe_id = ? ORDER BY ri.id ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $recipe_id);
$stmt->execute();
$items = $stmt->get_result();
$materials = $conn->query("SELECT id, code, name, uom FROM raw_materials ORDER BY name")->fetch_all(MYSQLI_ASSOC);
csrf_token();
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Ingredients for <?php echo h($recipe['code']); ?></h5>
      <p class="small text-muted mb-0">
        <?php echo h($recipe['product_name']); ?> • Yield: <?php echo (int)$recipe['yield_qty']; ?> pcs
      </p>
    </div>
    <a href="recipes_list.php" class="btn btn-sm btn-outline-light rounded-pill">
      <i class="fa-solid fa-arrow-left-long me-1"></i> Back
    </a>
  </div>
  <form method="post" action="items_save.php" class="small mb-3">
    <input type="hidden" name="recipe_id" value="<?php echo (int)$recipe_id; ?>">
    <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">
    <div class="row g-2 align-items-end">
      <div class="col-md-6">
        <label class="form-label mb-1">Material</label>
        <select name="material_id" class="form-select form-select-sm" required>
          <option value="">-- choose material --</option>
          <?php foreach($materials as $m): ?>
            <option value="<?php echo $m['id']; ?>">
              <?php echo h($m['code'] . " — " . $m['name'] . " (" . $m['uom'] . ")"); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3 col-6">
        <label class="form-label mb-1">Qty per batch</label>
        <input type="number" step="0.001" name="qty" class="form-control form-control-sm" required>
      </div>
      <div class="col-md-3 col-6 text-md-end">
        <button class="btn btn-sm btn-primary rounded-pill w-100" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
          <i class="fa-solid fa-plus me-1"></i> Add Ingredient
        </button>
      </div>
    </div>
  </form>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Material</th>
          <th>Qty / Batch</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php while($it = $items->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($it['material_name']); ?> <span class="text-muted">(<?php echo h($it['uom']); ?>)</span></td>
            <td><?php echo h($it['qty']); ?></td>
            <td class="text-end">
              <a href="items_delete.php?id=<?php echo $it['id']; ?>&recipe_id=<?php echo $recipe_id; ?>" class="btn btn-sm btn-outline-danger rounded-pill" onclick="return confirm('Remove ingredient?');">
                <i class="fa-solid fa-trash-can"></i>
              </a>
            </td>
          </tr>
        <?php endwhile; ?>
        <?php if ($items->num_rows === 0): ?>
          <tr><td colspan="3" class="text-center text-muted py-3">No ingredients yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
