<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$batch_date = $_POST['batch_date'] ?? date('Y-m-d');
$batch_no = trim($_POST['batch_no'] ?? '');
$product_id = (int)($_POST['product_id'] ?? 0);
$planned_qty = (int)($_POST['planned_qty'] ?? 0);
$actual_qty = (int)($_POST['actual_qty'] ?? 0);
$oven = trim($_POST['oven'] ?? '');
$notes = trim($_POST['notes'] ?? '');

if (!$batch_no || !$product_id) {
    flash_set('error', 'Fill required fields.');
    redirect("batch_form.php" . ($id ? "?id=".$id : ""));
}

if ($id) {
    $stmt = $conn->prepare("UPDATE production_batches SET batch_date=?, batch_no=?, product_id=?, planned_qty=?, actual_qty=?, oven=?, notes=? WHERE id=?");
    $stmt->bind_param("ssiiissi", $batch_date, $batch_no, $product_id, $planned_qty, $actual_qty, $oven, $notes, $id);
    $stmt->execute();
    flash_set('success', 'Batch updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO production_batches (batch_date,batch_no,product_id,planned_qty,actual_qty,oven,notes) VALUES (?,?,?,?,?,?,?)");
    $stmt->bind_param("ssiiiss", $batch_date, $batch_no, $product_id, $planned_qty, $actual_qty, $oven, $notes);
    $stmt->execute();
    flash_set('success', 'Batch created.');
}
redirect("batches_list.php");
