<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$reg_no = trim($_POST['reg_no'] ?? '');
$description = trim($_POST['description'] ?? '');
$capacity = trim($_POST['capacity'] ?? '');

if ($id) {
    $stmt = $conn->prepare("UPDATE vehicles SET reg_no=?, description=?, capacity=? WHERE id = ?");
    $stmt->bind_param("sssi", $reg_no, $description, $capacity, $id);
    $stmt->execute();
    flash_set('success', 'Vehicles updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO vehicles (reg_no, description, capacity) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $reg_no, $description, $capacity);
    $stmt->execute();
    flash_set('success', 'Vehicles created.');
}
redirect("vehicles_list.php");
