<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();
$page_title = "Edit Vehicles";

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM vehicles WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="row justify-content-center">
  <div class="col-lg-6 col-md-8">
    <div class="sb-card">
      <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Vehicles</h5>
      <form method="post" action="vehicles_save.php" class="small">
        <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

          <div class="mb-2">
            <label class="form-label">Reg No</label>
            <input type="text" name="reg_no" class="form-control form-control-sm" value="<?php echo h($row['reg_no'] ?? ''); ?>">
          </div>

          <div class="mb-2">
            <label class="form-label">Description</label>
            <input type="text" name="description" class="form-control form-control-sm" value="<?php echo h($row['description'] ?? ''); ?>">
          </div>

          <div class="mb-2">
            <label class="form-label">Capacity (bags/loaves)</label>
            <input type="text" name="capacity" class="form-control form-control-sm" value="<?php echo h($row['capacity'] ?? ''); ?>">
          </div>

        <div class="d-flex justify-content-between align-items-center mt-3">
          <a href="vehicles_list.php" class="btn btn-sm btn-outline-light rounded-pill">
            <i class="fa-solid fa-arrow-left-long me-1"></i> Back
          </a>
          <div class="d-flex gap-2">
            <?php if ($id): ?>
            <a href="vehicles_delete.php?id=<?php echo $id; ?>" class="btn btn-sm btn-outline-danger rounded-pill" onclick="return confirm('Delete this record?');">
              <i class="fa-solid fa-trash-can"></i>
            </a>
            <?php endif; ?>
            <button type="submit" class="btn btn-sm btn-primary rounded-pill" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
              <i class="fa-solid fa-floppy-disk me-1"></i> Save
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
