<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$code = trim($_POST['code'] ?? '');
$name = trim($_POST['name'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$contact_person = trim($_POST['contact_person'] ?? '');

if ($id) {
    $stmt = $conn->prepare("UPDATE suppliers SET code=?, name=?, phone=?, contact_person=? WHERE id = ?");
    $stmt->bind_param("ssssi", $code, $name, $phone, $contact_person, $id);
    $stmt->execute();
    flash_set('success', 'Suppliers updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO suppliers (code, name, phone, contact_person) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $code, $name, $phone, $contact_person);
    $stmt->execute();
    flash_set('success', 'Suppliers created.');
}
redirect("suppliers_list.php");
