<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$code = trim($_POST['code'] ?? '');
$name = trim($_POST['name'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$vehicle_assigned = trim($_POST['vehicle_assigned'] ?? '');

if ($id) {
    $stmt = $conn->prepare("UPDATE riders SET code=?, name=?, phone=?, vehicle_assigned=? WHERE id = ?");
    $stmt->bind_param("ssssi", $code, $name, $phone, $vehicle_assigned, $id);
    $stmt->execute();
    flash_set('success', 'Riders & Sales Staff updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO riders (code, name, phone, vehicle_assigned) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $code, $name, $phone, $vehicle_assigned);
    $stmt->execute();
    flash_set('success', 'Riders & Sales Staff created.');
}
redirect("riders_list.php");
