<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id            = (int)($_POST['id'] ?? 0);
$code          = trim($_POST['code'] ?? '');
$name          = trim($_POST['name'] ?? '');
$uom           = trim($_POST['uom'] ?? '');
$current_stock = (float)($_POST['current_stock'] ?? 0);
$unit_cost     = (float)($_POST['unit_cost'] ?? 0);

if (!$code || !$name || !$uom) {
    flash_set('error', 'Code, Name and UOM are required.');
    redirect("raw_materials_form.php" . ($id ? "?id=".$id : ""));
}

if ($id) {
    $stmt = $conn->prepare("UPDATE raw_materials 
        SET code=?, name=?, uom=?, current_stock=?, unit_cost=? 
        WHERE id=?");
    $stmt->bind_param("sssddi", $code, $name, $uom, $current_stock, $unit_cost, $id);
    $stmt->execute();
    flash_set('success', 'Material updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO raw_materials 
        (code, name, uom, current_stock, unit_cost) VALUES (?,?,?,?,?)");
    $stmt->bind_param("sssdd", $code, $name, $uom, $current_stock, $unit_cost);
    $stmt->execute();
    flash_set('success', 'Material created.');
}
redirect("raw_materials_list.php");
