<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id            = (int)($_POST['id'] ?? 0);
$code          = trim($_POST['code'] ?? '');
$name          = trim($_POST['name'] ?? '');
$category      = trim($_POST['category'] ?? '');
$uom           = trim($_POST['uom'] ?? 'PC');
$selling_price = (float)($_POST['selling_price'] ?? 0);
$status        = trim($_POST['status'] ?? 'Active');

if (!$code || !$name || !$category) {
    flash_set('error', 'Code, Name and Category are required.');
    redirect("products_form.php" . ($id ? "?id=".$id : ""));
}

if ($id) {
    $stmt = $conn->prepare("UPDATE products 
        SET code=?, name=?, category=?, uom=?, selling_price=?, status=? 
        WHERE id=?");
    $stmt->bind_param("ssssisi", $code, $name, $category, $uom, $selling_price, $status, $id);
    $stmt->execute();
    flash_set('success', 'Product updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO products 
        (code, name, category, uom, selling_price, status) 
        VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("ssssds", $code, $name, $category, $uom, $selling_price, $status);
    $stmt->execute();
    flash_set('success', 'Product created.');
}
redirect("products_list.php");
