<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();
$page_title = "Product (SKU)";

$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="row justify-content-center">
  <div class="col-lg-6 col-md-8">
    <div class="sb-card">
      <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Product</h5>
      <form method="post" action="products_save.php" class="small">
        <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

        <div class="mb-2">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control form-control-sm"
                 value="<?php echo h($row['code'] ?? ''); ?>" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Name</label>
          <input type="text" name="name" class="form-control form-control-sm"
                 value="<?php echo h($row['name'] ?? ''); ?>" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Category</label>
          <input type="text" name="category" class="form-control form-control-sm"
                 value="<?php echo h($row['category'] ?? 'BREAD'); ?>" required>
        </div>
        <div class="row g-2">
          <div class="col-md-4">
            <label class="form-label">UOM</label>
            <input type="text" name="uom" class="form-control form-control-sm"
                   value="<?php echo h($row['uom'] ?? 'PC'); ?>" required>
          </div>
          <div class="col-md-4">
            <label class="form-label">Selling Price (KES)</label>
            <input type="number" step="0.01" name="selling_price"
                   class="form-control form-control-sm"
                   value="<?php echo h($row['selling_price'] ?? '0'); ?>">
          </div>
          <div class="col-md-4">
            <label class="form-label">Status</label>
            <input type="text" name="status" class="form-control form-control-sm"
                   value="<?php echo h($row['status'] ?? 'Active'); ?>">
          </div>
        </div>

        <div class="d-flex justify-content-between align-items-center mt-3">
          <a href="products_list.php" class="btn btn-sm btn-outline-light rounded-pill">
            <i class="fa-solid fa-arrow-left-long me-1"></i> Back
          </a>
          <button type="submit" class="btn btn-sm btn-primary rounded-pill"
                  style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
            <i class="fa-solid fa-floppy-disk me-1"></i> Save
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
