<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Finished Goods Stock";

$sql = "
  SELECT fgs.product_id, fgs.on_hand,
         p.code, p.name, p.category
  FROM finished_goods_stock fgs
  JOIN products p ON fgs.product_id = p.id
  ORDER BY p.category, p.name
";
$res = $conn->query($sql);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Finished Goods Stock</h5>
      <p class="small text-muted mb-0">
        Loaves, cakes &amp; pastries currently in bakery store (after production &amp; dispatch posting).
      </p>
    </div>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Product</th>
          <th>Category</th>
          <th class="text-end">On Hand (pcs)</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $res->fetch_assoc()): ?>
          <tr>
            <td>
              <strong><?php echo h($row['code']); ?></strong><br>
              <span class="text-muted"><?php echo h($row['name']); ?></span>
            </td>
            <td><?php echo h($row['category']); ?></td>
            <td class="text-end"><?php echo number_format($row['on_hand']); ?></td>
          </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="3" class="text-center text-muted py-3">No finished goods yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
