<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$code = trim($_POST['code'] ?? '');
$name = trim($_POST['name'] ?? '');
$category = trim($_POST['category'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$route = trim($_POST['route'] ?? '');

if ($id) {
    $stmt = $conn->prepare("UPDATE customers SET code=?, name=?, category=?, phone=?, route=? WHERE id = ?");
    $stmt->bind_param("sssssi", $code, $name, $category, $phone, $route, $id);
    $stmt->execute();
    flash_set('success', 'Customers updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO customers (code, name, category, phone, route) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $code, $name, $category, $phone, $route);
    $stmt->execute();
    flash_set('success', 'Customers created.');
}
redirect("customers_list.php");
