<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$code = trim($_POST['code'] ?? '');
$branch_name = trim($_POST['branch_name'] ?? '');
$location = trim($_POST['location'] ?? '');

if ($id) {
    $stmt = $conn->prepare("UPDATE branches SET code=?, branch_name=?, location=? WHERE id = ?");
    $stmt->bind_param("sssi", $code, $branch_name, $location, $id);
    $stmt->execute();
    flash_set('success', 'Branches updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO branches (code, branch_name, location) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $code, $branch_name, $location);
    $stmt->execute();
    flash_set('success', 'Branches created.');
}
redirect("branches_list.php");
