<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Dispatch & Loading";

$sql = "SELECT dl.*, v.reg_no, r.name AS rider_name
        FROM dispatch_loads dl
        LEFT JOIN vehicles v ON dl.vehicle_id = v.id
        LEFT JOIN riders r ON dl.rider_id = r.id
        ORDER BY dl.load_date DESC, dl.id DESC";

$res = $conn->query($sql);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Dispatch Loading</h5>
      <p class="small text-muted mb-0">
        Move finished goods to vans/bikes, capture returns, and do route cash reconciliation.
      </p>
    </div>
    <a href="loading_form.php" class="btn btn-sm btn-primary rounded-pill"
       style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New Loading
    </a>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Date</th>
          <th>Load No</th>
          <th>Vehicle</th>
          <th>Rider</th>
          <th>Route</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($row['load_date']); ?></td>
            <td><?php echo h($row['load_no']); ?></td>
            <td><?php echo h($row['reg_no'] ?: '-'); ?></td>
            <td><?php echo h($row['rider_name'] ?: '-'); ?></td>
            <td><?php echo h($row['route_code']); ?></td>
            <td>
              <?php if ($row['status'] === 'Draft'): ?>
                <span class="badge rounded-pill text-bg-warning-subtle border border-warning-subtle">
                  Draft
                </span>
              <?php elseif ($row['status'] === 'Posted'): ?>
                <span class="badge rounded-pill text-bg-info-subtle border border-info-subtle">
                  Posted
                </span>
              <?php elseif ($row['status'] === 'Reconciled'): ?>
                <span class="badge rounded-pill text-bg-success-subtle border border-success-subtle">
                  Reconciled
                </span>
              <?php else: ?>
                <span class="badge rounded-pill text-bg-secondary-subtle border border-secondary-subtle">
                  <?php echo h($row['status']); ?>
                </span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <div class="btn-group btn-group-sm">
                <a href="loading_form.php?id=<?php echo $row['id']; ?>"
                   class="btn btn-outline-light rounded-pill">
                  <i class="fa-regular fa-pen-to-square"></i>
                </a>
                <?php if ($row['status'] === 'Draft'): ?>
                  <a href="loading_post.php?id=<?php echo $row['id']; ?>"
                     class="btn btn-outline-success rounded-pill"
                     onclick="return confirm('Post this loading and deduct finished goods stock?');">
                    <i class="fa-solid fa-arrow-up-right-from-square"></i> Post
                  </a>
                <?php endif; ?>
                <?php if ($row['status'] === 'Posted'): ?>
                  <a href="returns_form.php?id=<?php echo $row['id']; ?>"
                     class="btn btn-outline-warning rounded-pill">
                    <i class="fa-solid fa-arrow-rotate-left"></i> Returns &amp; Reconcile
                  </a>
                <?php endif; ?>
                <?php if ($row['status'] === 'Reconciled'): ?>
                  <a href="/smartbake360/modules/vansales/route_cash.php?load_id=<?php echo $row['id']; ?>"
                     class="btn btn-outline-primary rounded-pill">
                    <i class="fa-solid fa-sack-dollar"></i> Cash Reco
                  </a>
                <?php endif; ?>
              </div>
            </td>
          </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="7" class="text-center text-muted py-3">No loadings yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
