<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();
$page_title = "Dispatch Loading";

$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM dispatch_loads WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}

$vehicles = $conn->query("SELECT id, reg_no FROM vehicles ORDER BY reg_no")->fetch_all(MYSQLI_ASSOC);
$riders   = $conn->query("SELECT id, name FROM riders ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$products = $conn->query("SELECT id, code, name FROM products WHERE status='Active' ORDER BY category, name")->fetch_all(MYSQLI_ASSOC);

// Load existing items if editing
$items = [];
if ($id) {
    $stmt = $conn->prepare("SELECT dli.*, p.code, p.name 
                            FROM dispatch_load_items dli
                            JOIN products p ON dli.product_id = p.id
                            WHERE dli.load_id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Dispatch Loading</h5>
  <form method="post" action="loading_save.php" class="small">
    <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
    <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label">Load Date</label>
        <input type="date" name="load_date" class="form-control form-control-sm"
               value="<?php echo h($row['load_date'] ?? date('Y-m-d')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Load No</label>
        <input type="text" name="load_no" class="form-control form-control-sm"
               value="<?php echo h($row['load_no'] ?? 'LD-' . date('ymd-His')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Vehicle</label>
        <select name="vehicle_id" class="form-select form-select-sm">
          <option value="">-- none --</option>
          <?php foreach($vehicles as $v): ?>
            <option value="<?php echo $v['id']; ?>"
              <?php echo ($row['vehicle_id'] ?? 0) == $v['id'] ? 'selected' : ''; ?>>
              <?php echo h($v['reg_no']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Rider / Sales</label>
        <select name="rider_id" class="form-select form-select-sm">
          <option value="">-- none --</option>
          <?php foreach($riders as $r): ?>
            <option value="<?php echo $r['id']; ?>"
              <?php echo ($row['rider_id'] ?? 0) == $r['id'] ? 'selected' : ''; ?>>
              <?php echo h($r['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    <div class="row g-2 mt-2">
      <div class="col-md-4">
        <label class="form-label">Route Code / Name</label>
        <input type="text" name="route_code" class="form-control form-control-sm"
               value="<?php echo h($row['route_code'] ?? ''); ?>">
      </div>
    </div>

    <hr class="border-secondary my-3">

    <h6 class="text-uppercase text-muted small mb-2">Items to Load</h6>

    <div class="row g-2 align-items-end mb-2">
      <div class="col-md-6">
        <label class="form-label mb-1">Product</label>
        <select name="new_product_id" class="form-select form-select-sm">
          <option value="">-- select product --</option>
          <?php foreach($products as $p): ?>
            <option value="<?php echo $p['id']; ?>">
              <?php echo h($p['code'] . " — " . $p['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Qty Loaded</label>
        <input type="number" name="new_qty_loaded" class="form-control form-control-sm" min="0">
      </div>
      <div class="col-md-3">
        <button type="submit" name="add_item" value="1"
                class="btn btn-sm btn-primary rounded-pill w-100"
                style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
          <i class="fa-solid fa-plus me-1"></i> Add Item
        </button>
      </div>
    </div>

    <?php if (!empty($items)): ?>
      <div class="table-responsive small mb-2">
        <table class="table table-dark table-borderless align-middle mb-0">
          <thead class="text-muted text-uppercase small">
            <tr>
              <th>Product</th>
              <th class="text-end">Qty Loaded</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($items as $it): ?>
              <tr>
                <td><?php echo h($it['code']); ?> — <?php echo h($it['name']); ?></td>
                <td class="text-end"><?php echo (int)$it['qty_loaded']; ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mt-3">
      <a href="loadings_list.php" class="btn btn-sm btn-outline-light rounded-pill">
        <i class="fa-solid fa-arrow-left-long me-1"></i> Back
      </a>
      <button type="submit" name="save_header" value="1"
              class="btn btn-sm btn-primary rounded-pill"
              style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
        <i class="fa-solid fa-floppy-disk me-1"></i> Save
      </button>
    </div>
  </form>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
