<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";

$page_title = "Cake Orders";

// Load the latest 100 cake orders
$sql = "
  SELECT co.*, c.code AS customer_code, c.name AS customer_master_name
  FROM cake_orders co
  LEFT JOIN customers c ON co.customer_id = c.id
  ORDER BY co.order_date DESC, co.id DESC
  LIMIT 100
";
$res = $conn->query($sql);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>

<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Cake Orders</h5>
      <p class="small text-muted mb-0">
        Manage custom cake bookings, deposits & delivery dates.
      </p>
    </div>

    <a href="order_form.php"
       class="btn btn-sm btn-primary rounded-pill"
       style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New Cake Order
    </a>
  </div>

  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th style="width:10%;">Date</th>
          <th style="width:12%;">Order No</th>
          <th style="width:25%;">Customer</th>
          <th style="width:10%;">Event Date</th>
          <th style="width:13%;">Status</th>
          <th class="text-end" style="width:10%;">Total</th>
          <th class="text-end" style="width:10%;">Deposit</th>
          <th class="text-end" style="width:10%;">Balance</th>
          <th class="text-end" style="width:10%;">Actions</th>
        </tr>
      </thead>

      <tbody>
        <?php while($row = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($row['order_date']); ?></td>

            <td><?php echo h($row['order_no']); ?></td>

            <td>
              <?php if ($row['customer_code']): ?>
                <strong><?php echo h($row['customer_code']); ?></strong><br>
                <span class="text-muted"><?php echo h($row['customer_master_name']); ?></span>
              <?php else: ?>
                <strong><?php echo h($row['customer_name']); ?></strong><br>
                <span class="text-muted"><?php echo h($row['customer_phone']); ?></span>
              <?php endif; ?>
            </td>

            <td><?php echo h($row['event_date']); ?></td>

            <td>
              <?php
              $st = $row['status'];
              $badgeClass = "text-bg-secondary-subtle border border-secondary-subtle";

              if ($st === 'Enquiry')       $badgeClass = 'text-bg-warning-subtle border border-warning-subtle';
              if ($st === 'Confirmed')     $badgeClass = 'text-bg-info-subtle border border-info-subtle';
              if ($st === 'In Production') $badgeClass = 'text-bg-primary-subtle border border-primary-subtle';
              if ($st === 'Ready')         $badgeClass = 'text-bg-success-subtle border border-success-subtle';
              if ($st === 'Delivered')     $badgeClass = 'text-bg-success-subtle border border-success-subtle';
              if ($st === 'Cancelled')     $badgeClass = 'text-bg-danger-subtle border border-danger-subtle';
              ?>

              <span class="badge rounded-pill <?php echo $badgeClass; ?>">
                <?php echo h($st); ?>
              </span>

              <br>
              <span class="text-muted small">
                <?php echo h($row['payment_status']); ?>
              </span>
            </td>

            <td class="text-end">
              <?php echo number_format($row['total_amount'], 2); ?>
            </td>

            <td class="text-end">
              <?php echo number_format($row['deposit_amount'], 2); ?>
            </td>

            <td class="text-end">
              <?php echo number_format($row['balance_amount'], 2); ?>
            </td>

            <td class="text-end">
              <div class="btn-group btn-group-sm">
                <a href="order_form.php?id=<?php echo $row['id']; ?>"
                   class="btn btn-outline-light rounded-pill">
                  <i class="fa-regular fa-pen-to-square"></i>
                </a>

                <a href="order_print.php?id=<?php echo $row['id']; ?>"
                   class="btn btn-outline-primary rounded-pill"
                   target="_blank">
                  <i class="fa-solid fa-print"></i>
                </a>
              </div>
            </td>
          </tr>

        <?php endwhile; ?>

        <?php if ($res->num_rows === 0): ?>
          <tr>
            <td colspan="9" class="text-center text-muted py-3">
              No cake orders found.
            </td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
