<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id              = (int)($_POST['id'] ?? 0);
$order_date      = $_POST['order_date'] ?? date('Y-m-d');
$order_no        = trim($_POST['order_no'] ?? '');
$event_date      = $_POST['event_date'] ?? date('Y-m-d');
$event_type      = trim($_POST['event_type'] ?? '');
$customer_id     = !empty($_POST['customer_id']) ? (int)$_POST['customer_id'] : null;
$customer_name   = trim($_POST['customer_name'] ?? '');
$customer_phone  = trim($_POST['customer_phone'] ?? '');
$status          = trim($_POST['status'] ?? 'Enquiry');
$delivery_option = trim($_POST['delivery_option'] ?? 'Pickup');
$delivery_location = trim($_POST['delivery_location'] ?? '');
$deposit_amount  = (float)($_POST['deposit_amount'] ?? 0);
$notes           = trim($_POST['notes'] ?? '');

if (!$order_no || !$order_date || !$event_date || !$customer_name) {
    flash_set('error', 'Order date, order number, event date and customer name are required.');
    redirect("order_form.php" . ($id ? "?id=".$id : ""));
}

// Item arrays
$product_ids     = $_POST['product_id'] ?? [];
$descriptions    = $_POST['description'] ?? [];
$sizes           = $_POST['size'] ?? [];
$flavours        = $_POST['flavour'] ?? [];
$messages        = $_POST['message_on_cake'] ?? [];
$qtys            = $_POST['qty'] ?? [];
$unit_prices     = $_POST['unit_price'] ?? [];

$lines = [];
$total_amount = 0;

for ($i=0; $i<count($product_ids); $i++) {
    $pid   = !empty($product_ids[$i]) ? (int)$product_ids[$i] : null;
    $desc  = trim($descriptions[$i] ?? '');
    $size  = trim($sizes[$i] ?? '');
    $flav  = trim($flavours[$i] ?? '');
    $msg   = trim($messages[$i] ?? '');
    $qty   = (int)($qtys[$i] ?? 0);
    $price = (float)($unit_prices[$i] ?? 0);

    if (($pid || $desc) && $qty > 0 && $price > 0) {
        if ($desc === '' && $pid) {
            $desc = 'Cake item';
        }
        $lt = $qty * $price;
        $lines[] = [
            'product_id' => $pid,
            'description'=> $desc,
            'size'       => $size,
            'flavour'    => $flav,
            'message_on_cake' => $msg,
            'qty'        => $qty,
            'unit_price' => $price,
            'line_total' => $lt,
        ];
        $total_amount += $lt;
    }
}

if (empty($lines)) {
    flash_set('error', 'Add at least one cake line (description, qty, price).');
    redirect("order_form.php" . ($id ? "?id=".$id : ""));
}

$balance_amount = max(0, $total_amount - $deposit_amount);
if ($deposit_amount <= 0) {
    $payment_status = 'Pending';
} elseif ($balance_amount > 0) {
    $payment_status = 'Partially Paid';
} else {
    $payment_status = 'Paid';
}

$conn->begin_transaction();

try {
    if ($id) {
        // UPDATE header
        $stmt = $conn->prepare("
          UPDATE cake_orders
          SET order_no=?, order_date=?, customer_id=?, customer_name=?, customer_phone=?,
              event_date=?, event_type=?, status=?,
              total_amount=?, deposit_amount=?, balance_amount=?, payment_status=?,
              delivery_option=?, delivery_location=?, notes=?
          WHERE id=?
        ");
        $stmt->bind_param(
            "ssisssssdddssssi",
            $order_no,
            $order_date,
            $customer_id,
            $customer_name,
            $customer_phone,
            $event_date,
            $event_type,
            $status,
            $total_amount,
            $deposit_amount,
            $balance_amount,
            $payment_status,
            $delivery_option,
            $delivery_location,
            $notes,
            $id
        );
        $stmt->execute();

        // Remove old items
        $stmt = $conn->prepare("DELETE FROM cake_order_items WHERE cake_order_id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
    } else {
        // INSERT header
        $stmt = $conn->prepare("
          INSERT INTO cake_orders
          (order_no, order_date, customer_id, customer_name, customer_phone,
           event_date, event_type, status,
           total_amount, deposit_amount, balance_amount, payment_status,
           delivery_option, delivery_location, notes)
          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
        ");
        $stmt->bind_param(
            "ssisssssdddssss",
            $order_no,
            $order_date,
            $customer_id,
            $customer_name,
            $customer_phone,
            $event_date,
            $event_type,
            $status,
            $total_amount,
            $deposit_amount,
            $balance_amount,
            $payment_status,
            $delivery_option,
            $delivery_location,
            $notes
        );
        $stmt->execute();
        $id = $conn->insert_id;
    }

    // Insert items
    $stmtItem = $conn->prepare("
      INSERT INTO cake_order_items
      (cake_order_id, product_id, description, size, flavour, message_on_cake, qty, unit_price, line_total)
      VALUES (?,?,?,?,?,?,?,?,?)
    ");
    foreach ($lines as $ln) {
        $pid = $ln['product_id'];
        $desc= $ln['description'];
        $size= $ln['size'];
        $flav= $ln['flavour'];
        $msg = $ln['message_on_cake'];
        $qty = $ln['qty'];
        $up  = $ln['unit_price'];
        $lt  = $ln['line_total'];

        // product_id may be null
        if ($pid === null) {
            $null = null;
            $stmtItem->bind_param(
                "iissssidd",
                $id,
                $null,
                $desc,
                $size,
                $flav,
                $msg,
                $qty,
                $up,
                $lt
            );
        } else {
            $stmtItem->bind_param(
                "iissssidd",
                $id,
                $pid,
                $desc,
                $size,
                $flav,
                $msg,
                $qty,
                $up,
                $lt
            );
        }
        $stmtItem->execute();
    }

    $conn->commit();
    flash_set('success', 'Cake order saved.');
} catch (Exception $e) {
    $conn->rollback();
    flash_set('error', 'Error saving cake order: ' . $e->getMessage());
}

redirect("orders_list.php");
