<?php
session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: /smartbake360/index.php");
    exit;
}
$page_title = "Login";
require_once __DIR__ . "/../includes/helpers.php";
?>
<!doctype html>
<html lang="en" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <title>Login | SmartBake360</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <style>
    body {
      min-height: 100vh;
      background:
        radial-gradient(circle at top left, rgba(248,250,252,0.08), transparent 55%),
        #020617;
      display:flex;
      align-items:center;
      justify-content:center;
      color:#e5e7eb;
      font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif;
    }
    .login-card {
      width:100%;
      max-width:380px;
      background:rgba(15,23,42,0.98);
      border-radius:20px;
      border:1px solid rgba(148,163,184,0.35);
      box-shadow:0 30px 80px rgba(15,23,42,0.9);
      padding:1.4rem 1.5rem 1.3rem;
    }
    .logo {
      font-weight:800;
      font-size:1.4rem;
      letter-spacing:.14em;
      text-transform:uppercase;
    }
    .logo span { color:#f97316; }
    .pill {
      font-size:.72rem;
      text-transform:uppercase;
      letter-spacing:.16em;
      border-radius:999px;
      padding:.18rem .7rem;
      border:1px solid rgba(148,163,184,0.5);
      color:#9ca3af;
    }
  </style>
</head>
<body>
<div class="login-card">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div class="logo"><span>Smart</span>Bake</div>
    <div class="pill"><i class="fa-solid fa-bread-slice me-1"></i> ERP</div>
  </div>
  <p class="text-muted small mb-3">Sign in to manage bakery production, routes, and sales.</p>
  <?php if (!empty($_SESSION['login_error'])): ?>
    <div class="alert alert-danger py-2 small rounded-pill mb-2"><?php echo h($_SESSION['login_error']); unset($_SESSION['login_error']); ?></div>
  <?php endif; ?>
  <form method="post" action="login_handle.php" class="small">
    <div class="mb-2">
      <label class="form-label">Username</label>
      <input type="text" name="username" class="form-control form-control-sm" required>
    </div>
    <div class="mb-2">
      <label class="form-label d-flex justify-content-between align-items-center">
        <span>Password</span>
      </label>
      <input type="password" name="password" class="form-control form-control-sm" required>
    </div>
    <div class="d-flex justify-content-between align-items-center mt-3">
      <span class="text-muted small">Demo: <code>admin / admin123</code></span>
      <button type="submit" class="btn btn-sm btn-primary rounded-pill px-3" style="background:#f97316;border-color:#ea580c;">
        <i class="fa-solid fa-right-to-bracket me-1"></i> Login
      </button>
    </div>
  </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
