<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$from = (string)($_GET['from'] ?? date('Y-m-01'));
$to   = (string)($_GET['to'] ?? date('Y-m-d'));

$stmt = $pdo->prepare("SELECT
  (SELECT COALESCE(SUM(total),0) FROM pos_sales WHERE DATE(sale_time) BETWEEN ? AND ?) AS pos_sales,
  (SELECT COALESCE(SUM(sold_total),0) FROM trips WHERE trip_date BETWEEN ? AND ?) AS route_sales,
  (SELECT COALESCE(SUM(collected_total),0) FROM trips WHERE trip_date BETWEEN ? AND ?) AS route_collections,
  (SELECT COALESCE(SUM(amount),0) FROM expenses WHERE expense_date BETWEEN ? AND ?) AS expenses,
  (SELECT COALESCE(SUM(total_cost),0) FROM production_batches WHERE batch_date BETWEEN ? AND ?) AS production_cost
");
$stmt->execute([$from,$to,$from,$to,$from,$to,$from,$to,$from,$to]);
$k = $stmt->fetch() ?: [];

$revenue = (float)$k['pos_sales'] + (float)$k['route_sales'];
$profit_est = $revenue - (float)$k['production_cost'] - (float)$k['expenses'];

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="fw-semibold">Summary Report</div>
  <div class="muted">Period totals (KES)</div>
  <form class="row g-2 mt-2">
    <div class="col-md-3"><input class="form-control" type="date" name="from" value="<?= esc($from) ?>"></div>
    <div class="col-md-3"><input class="form-control" type="date" name="to" value="<?= esc($to) ?>"></div>
    <div class="col-md-3"><button class="btn btn-primary w-100">Run</button></div>
  </form>
</div>

<div class="row g-3">
  <div class="col-12 col-md-6">
    <div class="card p-3">
      <div class="muted">POS Sales</div><div class="fs-4 fw-semibold"><?= esc(money($k['pos_sales'] ?? 0)) ?></div>
    </div>
  </div>
  <div class="col-12 col-md-6">
    <div class="card p-3">
      <div class="muted">Route Sales</div><div class="fs-4 fw-semibold"><?= esc(money($k['route_sales'] ?? 0)) ?></div>
    </div>
  </div>
  <div class="col-12 col-md-6">
    <div class="card p-3">
      <div class="muted">Route Collections</div><div class="fs-4 fw-semibold"><?= esc(money($k['route_collections'] ?? 0)) ?></div>
    </div>
  </div>
  <div class="col-12 col-md-6">
    <div class="card p-3">
      <div class="muted">Expenses</div><div class="fs-4 fw-semibold"><?= esc(money($k['expenses'] ?? 0)) ?></div>
    </div>
  </div>
  <div class="col-12">
    <div class="card p-3">
      <div class="d-flex justify-content-between"><span class="muted">Production Cost (BOM-based)</span><span><?= esc(money($k['production_cost'] ?? 0)) ?></span></div>
      <div class="d-flex justify-content-between"><span class="muted">Revenue (POS + Route)</span><span><?= esc(money($revenue)) ?></span></div>
      <hr class="border-secondary">
      <div class="d-flex justify-content-between"><span class="fw-semibold">Estimated Profit</span><span class="fw-semibold"><?= esc(money($profit_est)) ?></span></div>
      <div class="small muted mt-2">MVP estimate: costs use avg purchase costs; improve later with FIFO/weighted average.</div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../_footer.php'; ?>
