<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$suppliers = $pdo->query("SELECT id,name FROM suppliers ORDER BY name")->fetchAll();
$items     = $pdo->query("SELECT id,name,uom FROM items ORDER BY name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $supplier_id = (int)($_POST['supplier_id'] ?? 0) ?: null;
  $inv_no = trim((string)($_POST['invoice_no'] ?? ''));
  $date = (string)($_POST['purchase_date'] ?? date('Y-m-d'));
  $notes = trim((string)($_POST['notes'] ?? ''));

  $lines = (array)($_POST['lines'] ?? []);
  $clean = [];
  foreach ($lines as $ln) {
    $item_id = (int)($ln['item_id'] ?? 0);
    $qty     = (float)($ln['qty'] ?? 0);
    $cost    = (float)($ln['unit_cost'] ?? 0);
    if ($item_id>0 && $qty>0) $clean[] = ['item_id'=>$item_id,'qty'=>$qty,'unit_cost'=>$cost];
  }
  if (!$clean) { $err='Add at least one line.'; }
  else {
    tx(function(PDO $pdo) use($supplier_id,$inv_no,$date,$notes,$clean,$u){
      $stmt = $pdo->prepare("INSERT INTO purchases(supplier_id, invoice_no, purchase_date, notes, created_by, created_at)
                             VALUES(?,?,?,?,?,NOW())");
      $stmt->execute([$supplier_id, $inv_no ?: null, $date, $notes ?: null, (int)($u['id'] ?? 0)]);
      $pid = (int)$pdo->lastInsertId();

      $stmtL = $pdo->prepare("INSERT INTO purchase_lines(purchase_id, item_id, qty, unit_cost) VALUES(?,?,?,?)");
      $stmtM = $pdo->prepare("INSERT INTO stock_moves(move_time, ref_type, ref_id, item_id, qty_in, qty_out, unit_cost, notes)
                              VALUES(NOW(),'PURCHASE',?,?,?,0,?,?)");
      foreach($clean as $c){
        $stmtL->execute([$pid, $c['item_id'], $c['qty'], $c['unit_cost']]);
        $stmtM->execute([$pid, $c['item_id'], $c['qty'], $c['unit_cost'], 'Goods received']);
      }
    });

    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Purchase received and stock updated.'];
    header('Location: ' . url('purchases/receive.php'));
    exit;
  }
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold">Receive Purchase</div>
  <div class="muted">Record supplier delivery and add stock</div>
  <?php if (!empty($err)): ?><div class="alert alert-danger mt-2"><?= esc($err) ?></div><?php endif; ?>
  <form method="post" class="row g-3 mt-1">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-4">
      <label class="form-label">Supplier</label>
      <select class="form-select" name="supplier_id">
        <option value="">—</option>
        <?php foreach($suppliers as $s): ?>
          <option value="<?= (int)$s['id'] ?>"><?= esc($s['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="small muted mt-1"><a href="<?= esc(url('settings/suppliers.php')) ?>">Manage suppliers</a></div>
    </div>
    <div class="col-md-3">
      <label class="form-label">Invoice No</label>
      <input class="form-control" name="invoice_no">
    </div>
    <div class="col-md-3">
      <label class="form-label">Purchase Date</label>
      <input class="form-control" name="purchase_date" type="date" value="<?= esc($_POST['purchase_date'] ?? date('Y-m-d')) ?>">
    </div>
    <div class="col-12">
      <label class="form-label">Notes</label>
      <input class="form-control" name="notes">
    </div>

    <div class="col-12">
      <div class="fw-semibold mb-2">Lines</div>
      <div id="lines"></div>
      <button type="button" class="btn btn-outline-light" onclick="addLine()">+ Add Line</button>
    </div>

    <div class="col-12">
      <button class="btn btn-primary">Save & Update Stock</button>
    </div>
  </form>
</div>

<script>
const items = <?= json.dumps(array_map(fn($i)=>['id'=>(int)$i['id'],'name'=>$i['name'],'uom'=>$i['uom']], $items)) ?>;
function addLine(){
  const wrap = document.getElementById('lines');
  const idx = wrap.children.length;
  const div = document.createElement('div');
  div.className = 'row g-2 mb-2';
  div.innerHTML = `
    <div class="col-md-6">
      <select class="form-select" name="lines[${idx}][item_id]" required>
        <option value="">Select item…</option>
        ${items.map(i=>`<option value="${i.id}">${i.name} (${i.uom})</option>`).join('')}
      </select>
    </div>
    <div class="col-md-3">
      <input class="form-control" name="lines[${idx}][qty]" type="number" step="0.01" placeholder="Qty" required>
    </div>
    <div class="col-md-3">
      <input class="form-control" name="lines[${idx}][unit_cost]" type="number" step="0.01" placeholder="Unit Cost (KES)">
    </div>`;
  wrap.appendChild(div);
}
addLine();
</script>
<?php include __DIR__ . '/../_footer.php'; ?>
