<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $cat = (string)($_POST['category'] ?? 'Bread');
  $sku = trim((string)($_POST['sku'] ?? ''));
  $name= trim((string)($_POST['name'] ?? ''));
  $uom = (string)($_POST['uom'] ?? 'pcs');
  $price = (float)($_POST['sell_price'] ?? 0);

  $stmt = $pdo->prepare("INSERT INTO products(category, sku, name, uom, sell_price, is_active, created_at)
                         VALUES(?,?,?,?,?,1,NOW())");
  $stmt->execute([$cat, $sku ?: null, $name, $uom, $price]);

  start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Product created. Add recipe (BOM) next.'];
  header('Location: ' . url('production/products.php'));
  exit;
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-2">Add Product</div>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-3">
      <label class="form-label">Category</label>
      <select class="form-select" name="category">
        <option>Bread</option><option>Cake</option><option>Pastry</option><option>Other</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">SKU (optional)</label>
      <input class="form-control" name="sku">
    </div>
    <div class="col-md-6">
      <label class="form-label">Name</label>
      <input class="form-control" name="name" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">UoM</label>
      <input class="form-control" name="uom" value="pcs" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Sell Price (KES)</label>
      <input class="form-control" name="sell_price" type="number" step="0.01" value="0">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-light" href="<?= esc(url('production/products.php')) ?>">Back</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
