<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM products WHERE id=?");
$stmt->execute([$id]);
$p = $stmt->fetch();
if (!$p) { http_response_code(404); exit('Not found'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $cat = (string)($_POST['category'] ?? $p['category']);
  $sku = trim((string)($_POST['sku'] ?? ''));
  $name= trim((string)($_POST['name'] ?? ''));
  $uom = (string)($_POST['uom'] ?? 'pcs');
  $price = (float)($_POST['sell_price'] ?? 0);
  $active = (int)($_POST['is_active'] ?? 1);

  $stmt = $pdo->prepare("UPDATE products SET category=?, sku=?, name=?, uom=?, sell_price=?, is_active=? WHERE id=?");
  $stmt->execute([$cat, $sku ?: null, $name, $uom, $price, $active, $id]);

  start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Product updated.'];
  header('Location: ' . url('production/products.php'));
  exit;
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-2">Edit Product</div>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-3">
      <label class="form-label">Category</label>
      <select class="form-select" name="category">
        <?php foreach(['Bread','Cake','Pastry','Other'] as $c): ?>
          <option <?= $p['category']===$c?'selected':'' ?>><?= esc($c) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">SKU</label>
      <input class="form-control" name="sku" value="<?= esc($p['sku']) ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">Name</label>
      <input class="form-control" name="name" value="<?= esc($p['name']) ?>" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">UoM</label>
      <input class="form-control" name="uom" value="<?= esc($p['uom']) ?>" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Sell Price (KES)</label>
      <input class="form-control" name="sell_price" type="number" step="0.01" value="<?= esc($p['sell_price']) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Active</label>
      <select class="form-select" name="is_active">
        <option value="1" <?= (int)$p['is_active']===1?'selected':'' ?>>Yes</option>
        <option value="0" <?= (int)$p['is_active']===0?'selected':'' ?>>No</option>
      </select>
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-light" href="<?= esc(url('production/products.php')) ?>">Back</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
