<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$rows = $pdo->query("SELECT pb.*, p.name product, p.category
                     FROM production_batches pb
                     JOIN products p ON p.id=pb.product_id
                     ORDER BY pb.id DESC LIMIT 200")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Production Batches</div>
      <div class="muted">Logs production & auto consumes raw materials via recipe (BOM)</div>
    </div>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-light" href="<?= esc(url('production/products.php')) ?>">Products & Recipes</a>
      <a class="btn btn-primary" href="<?= esc(url('production/new_batch.php')) ?>">Log Batch</a>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr>
        <th>Date</th><th>Product</th><th>Category</th><th class="text-end">Qty</th><th class="text-end">Unit Cost</th><th class="text-end">Total Cost</th>
      </tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= esc($r['batch_date']) ?></td>
            <td><?= esc($r['product']) ?></td>
            <td><?= esc($r['category']) ?></td>
            <td class="text-end"><?= esc(money($r['qty'])) ?></td>
            <td class="text-end"><?= esc(money($r['unit_cost'])) ?></td>
            <td class="text-end"><?= esc(money($r['total_cost'])) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
