<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$rows = $pdo->query("SELECT s.*, c.name customer
                     FROM pos_sales s
                     LEFT JOIN customers c ON c.id=s.customer_id
                     ORDER BY s.id DESC LIMIT 200")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Shop POS Sales</div>
      <div class="muted">Cash / M-Pesa / Bank + optional customer credit</div>
    </div>
    <a class="btn btn-primary" href="<?= esc(url('pos/new_sale.php')) ?>">New Sale</a>
  </div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr>
        <th>Time</th><th>Receipt</th><th>Customer</th><th>Pay</th><th class="text-end">Total</th>
      </tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= esc($r['sale_time']) ?></td>
            <td><?= esc($r['receipt_no']) ?></td>
            <td><?= esc($r['customer'] ?? 'Walk-in') ?></td>
            <td><?= esc($r['payment_method']) ?></td>
            <td class="text-end"><?= esc(money($r['total'])) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
