<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$products = $pdo->query("SELECT id,name,uom,sell_price FROM products WHERE is_active=1 ORDER BY category,name")->fetchAll();
$customers = $pdo->query("SELECT id,name,phone,balance FROM customers ORDER BY name")->fetchAll();

function next_receipt(PDO $pdo): string {
  $d = date('ymd');
  $n = (int)($pdo->query("SELECT COALESCE(COUNT(*),0) c FROM pos_sales WHERE DATE(sale_time)=CURDATE()")
               ->fetch()['c'] ?? 0) + 1;
  return sprintf("POS-%s-%04d", $d, $n);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $sale_time = now();
  $receipt = next_receipt($pdo);
  $customer_id = (int)($_POST['customer_id'] ?? 0) ?: null;
  $pay = (string)($_POST['payment_method'] ?? 'Cash');
  $mpesa = trim((string)($_POST['mpesa_ref'] ?? ''));
  $vat_mode = (int)($_POST['vat_mode'] ?? 0);

  $lines = (array)($_POST['lines'] ?? []);
  $clean = [];
  foreach ($lines as $ln) {
    $product_id = (int)($ln['product_id'] ?? 0);
    $qty = (float)($ln['qty'] ?? 0);
    $price = (float)($ln['unit_price'] ?? 0);
    if ($product_id>0 && $qty>0) $clean[] = compact('product_id','qty','price');
  }
  if (!$clean) $err='Add at least one product line.';
  else {
    $cfg = require __DIR__ . '/../../app/config.php';
    $vat_rate = (float)$cfg['vat_rate'];

    tx(function(PDO $pdo) use($sale_time,$receipt,$customer_id,$pay,$mpesa,$vat_mode,$clean,$u,$vat_rate){
      $subtotal = 0.0;
      foreach($clean as $c){ $subtotal += $c['qty'] * $c['price']; }
      $vat = $vat_mode ? ($subtotal * ($vat_rate/100.0)) : 0.0;
      $total = $subtotal + $vat;

      $stmt = $pdo->prepare("INSERT INTO pos_sales(sale_time, receipt_no, customer_id, payment_method, mpesa_ref, subtotal, vat_amount, total, created_by)
                             VALUES(?,?,?,?,?,?,?,?,?)");
      $stmt->execute([$sale_time,$receipt,$customer_id,$pay,$mpesa ?: null,$subtotal,$vat,$total,(int)($u['id'] ?? 0)]);
      $sid = (int)$pdo->lastInsertId();

      $stmtL = $pdo->prepare("INSERT INTO pos_sale_lines(pos_sale_id, product_id, qty, unit_price, line_total) VALUES(?,?,?,?,?)");
      $stmtM = $pdo->prepare("INSERT INTO finished_moves(move_time, ref_type, ref_id, product_id, qty_in, qty_out, unit_cost, notes)
                              VALUES(NOW(),'POS',?,?,0,?,0,'Sold via POS')");
      foreach($clean as $c){
        $line_total = $c['qty'] * $c['price'];
        $stmtL->execute([$sid, $c['product_id'], $c['qty'], $c['price'], $line_total]);
        $stmtM->execute([$sid, $c['product_id'], $c['qty']]);
      }

      // if credit, increase customer balance
      if ($customer_id && $pay === 'Credit') {
        $pdo->prepare("UPDATE customers SET balance = balance + ? WHERE id=?")->execute([$total, $customer_id]);
      }
    });

    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Sale saved: '.$receipt];
    header('Location: ' . url('pos/sales.php'));
    exit;
  }
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-1">New POS Sale</div>
  <div class="muted mb-3">Kenyan payments: Cash / M-Pesa / Bank / Credit</div>
  <?php if (!empty($err)): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">

    <div class="col-md-4">
      <label class="form-label">Customer (optional)</label>
      <select class="form-select" name="customer_id">
        <option value="">Walk-in</option>
        <?php foreach($customers as $c): ?>
          <option value="<?= (int)$c['id'] ?>"><?= esc($c['name']) ?> (<?= esc($c['phone']) ?>) • Due: <?= esc(money($c['balance'])) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="small muted mt-1"><a href="<?= esc(url('settings/customers.php')) ?>">Manage customers</a></div>
    </div>

    <div class="col-md-3">
      <label class="form-label">Payment</label>
      <select class="form-select" name="payment_method">
        <option>Cash</option><option>M-Pesa</option><option>Bank</option><option>Credit</option>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">M-Pesa Ref (optional)</label>
      <input class="form-control" name="mpesa_ref" placeholder="e.g. QWE12ABC3D">
    </div>

    <div class="col-md-2">
      <label class="form-label">Add VAT?</label>
      <select class="form-select" name="vat_mode">
        <option value="0">No</option>
        <option value="1">Yes (16%)</option>
      </select>
    </div>

    <div class="col-12">
      <div class="fw-semibold mb-2">Lines</div>
      <div id="lines"></div>
      <button type="button" class="btn btn-outline-light" onclick="addLine()">+ Add Product</button>
    </div>

    <div class="col-12">
      <button class="btn btn-primary">Save Sale</button>
      <a class="btn btn-outline-light" href="<?= esc(url('pos/sales.php')) ?>">Back</a>
    </div>
  </form>
</div>

<script>
const products = <?= json.dumps(array_map(fn($p)=>['id'=>(int)$p['id'],'name'=>$p['name'],'uom'=>$p['uom'],'price'=>(float)$p['sell_price']], $products)) ?>;
function addLine(){
  const wrap = document.getElementById('lines');
  const idx = wrap.children.length;
  const div = document.createElement('div');
  div.className = 'row g-2 mb-2';
  div.innerHTML = `
    <div class="col-md-6">
      <select class="form-select" name="lines[${idx}][product_id]" onchange="setPrice(this, ${idx})" required>
        <option value="">Select product…</option>
        ${products.map(p=>`<option value="${p.id}">${p.name} (${p.uom})</option>`).join('')}
      </select>
    </div>
    <div class="col-md-2">
      <input class="form-control" name="lines[${idx}][qty]" type="number" step="0.01" placeholder="Qty" required>
    </div>
    <div class="col-md-2">
      <input class="form-control" id="price_${idx}" name="lines[${idx}][unit_price]" type="number" step="0.01" placeholder="Unit price" required>
    </div>
    <div class="col-md-2">
      <button type="button" class="btn btn-outline-light w-100" onclick="this.closest('.row').remove()">Remove</button>
    </div>`;
  wrap.appendChild(div);
}
function setPrice(sel, idx){
  const id = sel.value;
  const p = products.find(x=>String(x.id)===String(id));
  if (p) document.getElementById('price_'+idx).value = p.price.toFixed(2);
}
addLine();
</script>
<?php include __DIR__ . '/../_footer.php'; ?>
