<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/helpers.php';

start_session();
$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');
  if (login($email, $pass)) {
    header('Location: ' . url('index.php'));
    exit;
  }
  $err = 'Invalid login. Please check email/password.';
}
?>
<!doctype html><html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#0b1220;color:#e8eefc;}
.card{max-width:420px;margin:8vh auto;background:rgba(255,255,255,.06);border:1px solid rgba(255,255,255,.1);border-radius:22px;}
.form-control{background:rgba(255,255,255,.08);color:#e8eefc;border:1px solid rgba(255,255,255,.15);border-radius:14px;}
</style></head><body>
<div class="card p-4">
  <h4 class="mb-1">Bakery360 MVP</h4>
  <div class="text-muted mb-3">Sign in to continue</div>
  <?php if ($err): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>
  <form method="post">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="mb-3">
      <label class="form-label">Email</label>
      <input class="form-control" name="email" value="<?= esc($_POST['email'] ?? 'admin@bakery.local') ?>" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Password</label>
      <input class="form-control" name="password" type="password" value="<?= esc($_POST['password'] ?? '') ?>" required>
    </div>
    <button class="btn btn-primary w-100">Login</button>
  </form>
  <div class="small text-muted mt-3">Default: admin@bakery.local / Admin@1234</div>
</div>
</body></html>
