<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $type = (string)($_POST['type'] ?? 'Raw');
  $sku  = trim((string)($_POST['sku'] ?? ''));
  $name = trim((string)($_POST['name'] ?? ''));
  $uom  = (string)($_POST['uom'] ?? 'kg');
  $reorder = (float)($_POST['reorder_level'] ?? 0);

  $stmt = $pdo->prepare("INSERT INTO items(type, sku, name, uom, reorder_level, created_at) VALUES(?,?,?,?,?,NOW())");
  $stmt->execute([$type, $sku ?: null, $name, $uom, $reorder]);

  start_session(); $_SESSION['flash'] = ['type'=>'success','msg'=>'Item created.'];
  header('Location: ' . url('inventory/items.php'));
  exit;
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-2">Add Inventory Item</div>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-3">
      <label class="form-label">Type</label>
      <select class="form-select" name="type">
        <option>Raw</option><option>Packaging</option><option>Other</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">SKU (optional)</label>
      <input class="form-control" name="sku">
    </div>
    <div class="col-md-6">
      <label class="form-label">Name</label>
      <input class="form-control" name="name" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Unit of Measure</label>
      <select class="form-select" name="uom">
        <option value="kg">kg</option><option value="g">g</option><option value="l">l</option><option value="ml">ml</option>
        <option value="pcs">pcs</option><option value="bags">bags</option><option value="boxes">boxes</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Reorder Level</label>
      <input class="form-control" name="reorder_level" type="number" step="0.01" value="0">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-light" href="<?= esc(url('inventory/items.php')) ?>">Back</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
