<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM items WHERE id=?");
$stmt->execute([$id]);
$item = $stmt->fetch();
if (!$item) { http_response_code(404); exit('Item not found'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $type = (string)($_POST['type'] ?? $item['type']);
  $sku  = trim((string)($_POST['sku'] ?? ''));
  $name = trim((string)($_POST['name'] ?? ''));
  $uom  = (string)($_POST['uom'] ?? $item['uom']);
  $reorder = (float)($_POST['reorder_level'] ?? 0);

  $stmt = $pdo->prepare("UPDATE items SET type=?, sku=?, name=?, uom=?, reorder_level=? WHERE id=?");
  $stmt->execute([$type, $sku ?: null, $name, $uom, $reorder, $id]);

  start_session(); $_SESSION['flash'] = ['type'=>'success','msg'=>'Item updated.'];
  header('Location: ' . url('inventory/items.php'));
  exit;
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-2">Edit Item</div>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-3">
      <label class="form-label">Type</label>
      <select class="form-select" name="type">
        <?php foreach(['Raw','Packaging','Other'] as $t): ?>
          <option <?= $item['type']===$t?'selected':'' ?>><?= esc($t) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">SKU</label>
      <input class="form-control" name="sku" value="<?= esc($item['sku']) ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">Name</label>
      <input class="form-control" name="name" value="<?= esc($item['name']) ?>" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">UoM</label>
      <input class="form-control" name="uom" value="<?= esc($item['uom']) ?>" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Reorder Level</label>
      <input class="form-control" name="reorder_level" type="number" step="0.01" value="<?= esc($item['reorder_level']) ?>">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-light" href="<?= esc(url('inventory/items.php')) ?>">Back</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
