<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$rows = $pdo->query("SELECT * FROM expenses ORDER BY expense_date DESC, id DESC LIMIT 200")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Expenses</div>
      <div class="muted">Fuel, salaries, electricity, repairs, packaging, etc.</div>
    </div>
    <a class="btn btn-primary" href="<?= esc(url('expenses/new_expense.php')) ?>">New Expense</a>
  </div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr>
        <th>Date</th><th>Category</th><th>Description</th><th class="text-end">Amount</th><th>Payment</th>
      </tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= esc($r['expense_date']) ?></td>
            <td><?= esc($r['category']) ?></td>
            <td><?= esc($r['description']) ?></td>
            <td class="text-end"><?= esc(money($r['amount'])) ?></td>
            <td><?= esc($r['payment_method']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
