<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/auth.php';
$cfg = require __DIR__ . '/../app/config.php';
$APP = $cfg['app_name'];
$CUR = $cfg['currency'];
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($APP) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #0b1220; color: #e8eefc; }
    .card { background: rgba(255,255,255,0.06); border: 1px solid rgba(255,255,255,0.1); border-radius: 18px; }
    .navlink { color:#cfe0ff; text-decoration:none; padding:.5rem .75rem; border-radius:12px; display:inline-block; }
    .navlink:hover { background: rgba(255,255,255,0.08); }
    .muted { color:#a6b7dc; }
    .btn-primary { border-radius: 14px; }
    .table { color:#e8eefc; }
    .table thead th { color:#cfe0ff; }
    .form-control, .form-select { background: rgba(255,255,255,0.08); color:#e8eefc; border: 1px solid rgba(255,255,255,0.15); border-radius: 14px; }
    .form-control:focus, .form-select:focus { box-shadow:none; border-color: rgba(99,179,237,.9); }
    a { color:#9bd1ff; }
  </style>
</head>
<body>
<nav class="container-fluid py-3">
  <div class="container d-flex justify-content-between align-items-center">
    <div class="d-flex gap-2 align-items-center">
      <span class="fw-semibold"><?= esc($APP) ?></span>
      <span class="badge text-bg-info">KES</span>
    </div>
    <div class="d-flex gap-2 flex-wrap">
      <a class="navlink" href="<?= esc(url('index.php')) ?>">Dashboard</a>
      <a class="navlink" href="<?= esc(url('inventory/items.php')) ?>">Inventory</a>
      <a class="navlink" href="<?= esc(url('purchases/receive.php')) ?>">Purchases</a>
      <a class="navlink" href="<?= esc(url('production/batches.php')) ?>">Production</a>
      <a class="navlink" href="<?= esc(url('pos/sales.php')) ?>">Shop POS</a>
      <a class="navlink" href="<?= esc(url('distribution/trips.php')) ?>">Distribution</a>
      <a class="navlink" href="<?= esc(url('expenses/expenses.php')) ?>">Expenses</a>
      <a class="navlink" href="<?= esc(url('reports/summary.php')) ?>">Reports</a>
      <a class="navlink" href="<?= esc(url('settings/users.php')) ?>">Settings</a>
      <a class="navlink" href="<?= esc(url('logout.php')) ?>">Logout</a>
    </div>
  </div>
</nav>
<main class="container pb-5">
